//
//  MCClientServerChangeManager.h
//  MCBasicSync
//
//  Created by Brent Gulanowski on 25/04/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//

#import <MCServerSupport/MCChangeManager.h>


extern NSString *kMCTemporaryFolderName;


@class MCClientStage;

@interface MCServerChangeManager : MCChangeManager {

	MCClientStage *stage;
	
	MCChangeSet *changesToApply;
}

+ (NSString *)applyFolderName;

- (MCClientStage *)clientStage;

- (MCChangeSet *)changesToApply;
- (void)setChangesToApply:(MCChangeSet *)aChangeSet;

// @throws NSInternalInconsistencyException if previously set database UUID (in stage settings) does not dbUUID provided
- (id)initWithClientStage:(MCClientStage *)aStage
			   databaseID:(NSString *)dbUUID
				  version:(unsigned)aVersion;

- (NSString *)applyChangeSetFolder;

- (NSUInteger)numberOfChangeSetsInApplyFolder;

- (NSString *)uniqueApplyChangeSetPath;

- (MCChangeSet *)newAutoreleasedApplyChangeSet;

+ (NSString *)coaleaseFolderName;
- (NSString *)coaleaseFolder;
- (NSString *)coaleaseApplyFolder;
- (NSString *)coaleaseOutgoingFolder;


@end

@interface MCServerChangeManager (MCServerChangeManagerSubclasses)

- (void)reconcile;

@end

